import sys
import math

def distance_to_rope(point, rope):
    """
    ?????? ???????? ????????? ?? ????? (x, h) ?? ??????.
    ????? ?? ????????? ????? ??????? ((x1, h1), (x2, h2)).
    """
    x, h = point
    (x1, h1), (x2, h2) = rope
    
    # ??? ?? ?????? ????? ???? ?? ??? ????? ??????, ???? ???????? ?????
    if h > max(h1, h2):
        return float('inf')
    
    # ????????? ????? ??????? ??????
    x0 = (h1 + x1 - h2 + x2) / 2.0
    y0 = h1 + x1 - x0
    
    # ??? ?? ?????? ????? ????? ??? ??????, ???????? ????? ?? ???
    if h <= y0:
        return math.sqrt((x - x0)**2 + (h - y0)**2)
    
    # ?????, ??????? ????? ?? ?????? ??? ?? y = h
    min_dist = float('inf')
    
    # ??????? ???? ?????? ?????? (????? -1)
    if h1 >= h:
        x_left = h1 + x1 - h
        if x1 <= x_left <= x0:
            min_dist = min(min_dist, abs(x - x_left))
    
    # ??????? ????? ?????? ?????? (????? +1)
    if h2 >= h:
        x_right = h + x2 - h2
        if x0 <= x_right <= x2:
            min_dist = min(min_dist, abs(x - x_right))
    
    return min_dist

def solve():
    # ?????? ?????
    input = sys.stdin.read().split()
    ptr = 0
    n = int(input[ptr]); ptr += 1
    
    xs = list(map(int, input[ptr:ptr+n])); ptr += n
    hs = list(map(int, input[ptr:ptr+n])); ptr += n
    
    # ???????? ? ???????? ??????? ?? x ??????????
    masts = list(zip(xs, hs))
    masts.sort()
    
    # ???????? ?????? ?????? ?????? ???????? ???????
    ropes = []
    for i in range(n-1):
        ropes.append((masts[i], masts[i+1]))
    
    # ?????? ????? ??????
    results = []
    for i in range(n):
        x_i, h_i = masts[i]
        min_dist = float('inf')
        
        # ??????? ??? ????? ???????
        for j in range(n):
            if i == j:
                continue
            x_j, h_j = masts[j]
            if h_j >= h_i:
                dist = math.sqrt((x_i - x_j)**2 + (h_i - h_j)**2)
                min_dist = min(min_dist, dist)
        
        # ??????? ??? ??????
        for rope in ropes:
            dist = distance_to_rope((x_i, h_i), rope)
            min_dist = min(min_dist, dist)
        
        # ????? ????????
        if min_dist == float('inf'):
            results.append("-1")
        else:
            # ???????? ?? ???????? ??? ???? (????????? ?????? ?? ??????????)
            results.append(str(int(round(min_dist))))
    
    # ????? ?????????
    sys.stdout.write("\n".join(results))

if __name__ == "__main__":
    solve()